* Tdubius_bait_color_unbalanced.sas;
options pageno=1 linesize=80;
goptions reset=all;
title "Two-way ANOVA for T. dubius counts";
title2 "Data from Reeve et al. (2009)";
data Tdubius;
	input bait $ color $ Tdubius;
	* Apply transformations here;
	y = log10(Tdubius+1);
	datalines;
FRT	B	18
FRT	W	12
FRT	W	15
FRT	W	7
FRT	W	4
IDT	B	2
IDT	B	1
IDT	B	4
IDT	W	2
IDT	W	1
IST	B	2
IST	B	2
IST	B	10
IST	B	7
IST	W	4
;
run;
* Print data set;
proc print data=Tdubius;
run;
* Plot means, standard errors, and observations;
proc gplot data=Tdubius;
	plot y*bait=color / vaxis=axis1 haxis=axis1 legend=legend1;
	symbol1 i=std1mjt v=star height=2 width=3;
	axis1 label=(height=2) value=(height=2) width=3 major=(width=2) minor=none;
	legend1 label=(height=2) value=(height=2);
run;
* Two-way ANOVA with all fixed effects;
proc glm data=Tdubius;
	class bait color;
	model y = bait color bait*color / ss2 ss3;
	lsmeans bait color / adjust=tukey cl lines;
	output out=resids p=pred r=resid;
run;
goptions reset=all;
title "Diagnostic plots to check anova assumptions";
* Plot residuals vs. predicted values;
proc gplot data=resids;
	plot resid*pred=1 / vaxis=axis1 haxis=axis1;
	symbol1 v=star height=2 width=3;
	axis1 label=(height=2) value=(height=2) width=3 major=(width=2) minor=none;run;
* Normal quantile plot of residuals;
proc univariate noprint data=resids;
	qqplot resid / normal waxis=3 height=4;
run;
quit;
